<?php $__env->startSection('head'); ?>
    <script type="text/javascript" src="<?php echo e(config('voyager.assets_path')); ?>/lib/js/jsonarea/jsonarea.min.js"></script>
    <script>var valid_json = [];</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>
    <div class="page-title">
        <i class="voyager-data"></i> <?php if(isset($dataType->id)): ?><?php echo e('Edit BREAD for ' . $dataType->name . ' table'); ?><?php elseif(isset($table)): ?><?php echo e('Create BREAD for ' . $table . ' table'); ?><?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php if(isset($dataType->name)): ?>
        <?php $table = $dataType->name ?>
    <?php endif; ?>

    <div class="page-content container-fluid">
        <div class="row">
            <div class="col-md-12">

                <form role="form"
                      action="<?php if(isset($dataType->id)): ?><?php echo e(route('voyager.database.update_bread', $dataType->id)); ?><?php else: ?><?php echo e(route('voyager.database.store_bread')); ?><?php endif; ?>"
                      method="POST">
                    <?php if(isset($dataType->id)): ?>
                        <input type="hidden" value="<?php echo e($dataType->id); ?>" name="id">
                        <?php echo e(method_field("PUT")); ?>

                    <?php endif; ?>
                    <!-- CSRF TOKEN -->
                    <?php echo e(csrf_field()); ?>


                    <div class="panel panel-primary panel-bordered">

                        <div class="panel-heading">
                            <h3 class="panel-title">Edit the rows for the <?php echo e($table); ?> table below:</h3>
                        </div>

                        <table id="users" class="table table-hover">
                            <thead>
                            <tr>
                                <th>Field</th>
                                <th>Field Info</th>
                                <th>Visibility</th>
                                <th>Input Type</th>
                                <th>Display Name</th>
                                <th>Optional Details</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $fieldOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>

                                <?php if(isset($dataType->id)): ?>
                                    <?php $dataRow = TCG\Voyager\Models\DataRow::where('data_type_id', '=',
                                            $dataType->id)->where('field', '=', $data['field'])->first(); ?>
                                <?php endif; ?>
                                <tr>
                                    <td><h4><strong><?php echo e($data['field']); ?></strong></h4></td>
                                    <td>
                                        <strong>Type:</strong> <span><?php echo e($data['type']); ?></span><br/>
                                        <strong>Key:</strong> <span><?php echo e($data['key']); ?></span><br/>
                                        <strong>Required:</strong>
                                        <?php if($data['null'] == "NO"): ?>
                                            <span>Yes</span>
                                            <input type="hidden" value="1" name="field_required_<?php echo e($data['field']); ?>"
                                                   checked="checked">
                                        <?php else: ?>
                                            <span>No</span>
                                            <input type="hidden" value="0" name="field_required_<?php echo e($data['field']); ?>">
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <input type="checkbox"
                                               id="field_browse_<?php echo e($data['field']); ?>"
                                               name="field_browse_<?php echo e($data['field']); ?>" <?php if(isset($dataRow->browse) && $dataRow->browse): ?><?php echo e('checked="checked"'); ?><?php elseif($data['key'] == 'PRI'): ?><?php elseif($data['type'] == 'timestamp' && $data['field'] == 'updated_at'): ?><?php elseif(!isset($dataRow->browse)): ?><?php echo e('checked="checked"'); ?><?php endif; ?>>
                                        <label for="field_browse_<?php echo e($data['field']); ?>">Browse</label><br/>
                                        <input type="checkbox"
                                               id="field_read_<?php echo e($data['field']); ?>"
                                               name="field_read_<?php echo e($data['field']); ?>" <?php if(isset($dataRow->read) && $dataRow->read): ?><?php echo e('checked="checked"'); ?><?php elseif($data['key'] == 'PRI'): ?><?php elseif($data['key'] == 'timestamp' && $data['field'] == 'updated_at'): ?><?php elseif(!isset($dataRow->read)): ?><?php echo e('checked="checked"'); ?><?php endif; ?>>
                                        <label for="field_read_<?php echo e($data['field']); ?>">Read</label><br/>
                                        <input type="checkbox"
                                               id="field_edit_<?php echo e($data['field']); ?>"
                                               name="field_edit_<?php echo e($data['field']); ?>" <?php if(isset($dataRow->edit) && $dataRow->edit): ?><?php echo e('checked="checked"'); ?><?php elseif($data['key'] == 'PRI'): ?><?php elseif($data['key'] == 'timestamp' && $data['field'] == 'updated_at'): ?><?php elseif(!isset($dataRow->edit)): ?><?php echo e('checked="checked"'); ?><?php endif; ?>>
                                        <label for="field_edit_<?php echo e($data['field']); ?>">Edit</label><br/>
                                        <input type="checkbox"
                                               id="field_add_<?php echo e($data['field']); ?>"
                                               name="field_add_<?php echo e($data['field']); ?>" <?php if(isset($dataRow->add) && $dataRow->add): ?><?php echo e('checked="checked"'); ?><?php elseif($data['key'] == 'PRI'): ?><?php elseif($data['key'] == 'timestamp' && $data['field'] == 'created_at'): ?><?php elseif($data['key'] == 'timestamp' && $data['field'] == 'updated_at'): ?><?php elseif(!isset($dataRow->add)): ?><?php echo e('checked="checked"'); ?><?php endif; ?>>
                                            <label for="field_add_<?php echo e($data['field']); ?>">Add</label><br/>
                                        <input type="checkbox"
                                               id="field_delete_<?php echo e($data['field']); ?>"
                                               name="field_delete_<?php echo e($data['field']); ?>" <?php if(isset($dataRow->delete) && $dataRow->delete): ?><?php echo e('checked="checked"'); ?><?php elseif($data['key'] == 'PRI'): ?><?php elseif($data['key'] == 'timestamp' && $data['field'] == 'updated_at'): ?><?php elseif(!isset($dataRow->delete)): ?><?php echo e('checked="checked"'); ?><?php endif; ?>>
                                                <label for="field_delete_<?php echo e($data['field']); ?>">Delete</label><br/>
                                    </td>
                                    <input type="hidden" name="field_<?php echo e($data['field']); ?>" value="<?php echo e($data['field']); ?>">
                                    <td>
                                        <?php if($data['key'] == 'PRI'): ?>
                                            <p>Primary Key</p>
                                            <input type="hidden" value="PRI" name="field_input_type_<?php echo e($data['field']); ?>">
                                        <?php elseif($data['key'] == 'timestamp'): ?>
                                            <p>Timestamp</p>
                                            <input type="hidden" value="timestamp"
                                                   name="field_input_type_<?php echo e($data['field']); ?>">
                                        <?php else: ?>
                                            <select name="field_input_type_<?php echo e($data['field']); ?>">
                                                <option value="text" <?php if(isset($dataRow->type) && $dataRow->type == 'text'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Text Box
                                                </option>
                                                <option value="text_area" <?php if(isset($dataRow->type) && $dataRow->type == 'text_area'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Text Area
                                                </option>
                                                <option value="rich_text_box" <?php if(isset($dataRow->type) && $dataRow->type == 'rich_text_box'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Rich Textbox
                                                </option>
                                                <option value="password" <?php if(isset($dataRow->type) && $dataRow->type == 'password'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Password
                                                </option>
                                                <option value="hidden" <?php if(isset($dataRow->type) && $dataRow->type == 'hidden'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Hidden
                                                </option>
                                                <option value="checkbox" <?php if(isset($dataRow->type) && $dataRow->type == 'checkbox'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Check Box
                                                </option>
                                                <option value="radio_btn" <?php if(isset($dataRow->type) && $dataRow->type == 'radio_btn'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Radio Button
                                                </option>
                                                <option value="select_dropdown" <?php if(isset($dataRow->type) && $dataRow->type == 'select_dropdown'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Select Dropdown
                                                </option>
                                                </option>
                                                <option value="select_multiple" <?php if(isset($dataRow->type) && $dataRow->type == 'select_multiple'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Multiple Select
                                                </option>
                                                <option value="file" <?php if(isset($dataRow->type) && $dataRow->type == 'file'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    File
                                                </option>
                                                <option value="image" <?php if(isset($dataRow->type) && $dataRow->type == 'image'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Image
                                                </option>
                                                <option value="date" <?php if(isset($dataRow->type) && $dataRow->type == 'date'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Date
                                                </option>
                                                <option value="date-time" <?php if(isset($dataRow->type) && $dataRow->type == 'date-time'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Date Time
                                                </option>
                                                <option value="number" <?php if(isset($dataRow->type) && $dataRow->type == 'number'): ?><?php echo e('selected'); ?><?php endif; ?>>
                                                    Number
                                                </option>
                                            </select>
                                        <?php endif; ?>

                                    </td>
                                    <td><input type="text" class="form-control"
                                               value="<?php if(isset($dataRow->display_name)): ?><?php echo e($dataRow->display_name); ?><?php else: ?><?php echo e(ucwords(str_replace('_', ' ', $data['field']))); ?><?php endif; ?>"
                                               name="field_display_name_<?php echo e($data['field']); ?>"></td>
                                    <td>
                                        <textarea class="form-control json" name="field_details_<?php echo e($data['field']); ?>"
                                                  id="field_details_<?php echo e($data['field']); ?>"><?php if(isset($dataRow->details)): ?><?php echo e($dataRow->details); ?><?php endif; ?></textarea>
                                        <div id="field_details_<?php echo e($data['field']); ?>_valid" class="alert-success alert"
                                             style="display:none">Valid Json
                                        </div>
                                        <div id="field_details_<?php echo e($data['field']); ?>_invalid" class="alert-danger alert"
                                             style="display:none">Invalid Json
                                        </div>
                                    </td>
                                </tr>

                                <script>
                                    // do the deal
                                    var myJSONArea = JSONArea(document.getElementById('field_details_<?php echo e($data['field']); ?>'), {
                                        sourceObjects: [] // optional array of objects for JSONArea to inherit from
                                    });

                                    valid_json["field_details_<?php echo e($data['field']); ?>"] = false;

                                    // then here's how you use JSONArea's update event
                                    myJSONArea.getElement().addEventListener('update', function (e) {

                                        if (e.target.value != "") {
                                            valid_json["field_details_<?php echo e($data['field']); ?>"] = e.detail.isJSON;
                                        }
                                    });

                                    // then here's how you use JSONArea's update event
                                    myJSONArea.getElement().addEventListener('focusout', function (e) {
                                        if (valid_json['field_details_<?php echo e($data['field']); ?>']) {
                                            $('#field_details_<?php echo e($data['field']); ?>_valid').show();
                                            $('#field_details_<?php echo e($data['field']); ?>_invalid').hide();
                                            var ugly = e.target.value;
                                            var obj = JSON.parse(ugly);
                                            var pretty = JSON.stringify(obj, undefined, 4);
                                            document.getElementById('field_details_<?php echo e($data['field']); ?>').value = pretty;
                                        } else {
                                            $('#field_details_<?php echo e($data['field']); ?>_valid').hide();
                                            $('#field_details_<?php echo e($data['field']); ?>_invalid').show();
                                        }
                                    });
                                </script>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                            </tbody>
                        </table>

                    </div><!-- .panel -->

                    <div class="panel panel-primary panel-bordered">

                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(ucfirst($table)); ?> BREAD info</h3>
                        </div>

                        <div class="panel-body">
                            <div class="form-group">
                                <label for="name">Table Name</label>
                                <input type="text" class="form-control" readonly name="name" placeholder="Name"
                                       value="<?php if(isset($dataType->name)): ?><?php echo e($dataType->name); ?><?php else: ?><?php echo e($table); ?><?php endif; ?>">
                            </div>
                            <div class="form-group">
                                <label for="email">URL Slug (must be unique)</label>
                                <input type="text" class="form-control" name="slug" placeholder="URL slug (ex. posts)"
                                       value="<?php if(isset($dataType->slug)): ?><?php echo e($dataType->slug); ?><?php else: ?><?php echo e($slug); ?><?php endif; ?>">
                            </div>
                            <div class="form-group">
                                <label for="email">Display Name (Singular)</label>
                                <input type="text" class="form-control" name="display_name_singular"
                                       placeholder="Display Name (Singular)"
                                       value="<?php if(isset($dataType->display_name_singular)): ?><?php echo e($dataType->display_name_singular); ?><?php else: ?><?php echo e($display_name); ?><?php endif; ?>">
                            </div>
                            <div class="form-group">
                                <label for="email">Display Name (Plural)</label>
                                <input type="text" class="form-control" name="display_name_plural"
                                       placeholder="Display Name (Plural)"
                                       value="<?php if(isset($dataType->display_name_plural)): ?><?php echo e($dataType->display_name_plural); ?><?php else: ?><?php echo e($display_name_plural); ?><?php endif; ?>">
                            </div>
                            <div class="form-group">
                                <label for="email">Icon (optional) Use a <a
                                            href="<?php echo e(config('voyager.assets_path') . '/fonts/voyager/icons-reference.html'); ?>"
                                            target="_blank">Voyager Font Class</a></label>
                                <input type="text" class="form-control" name="icon"
                                       placeholder="Icon to use for this Table"
                                       value="<?php if(isset($dataType->icon)): ?><?php echo e($dataType->icon); ?><?php endif; ?>">
                            </div>
                            <div class="form-group">
                                <label for="email">Model Name (ex. \App\User, if left empty will try and use the table
                                    name)</label>
                                <input type="text" class="form-control" name="model_name" placeholder="Model Class Name"
                                       value="<?php if(isset($dataType->model_name)): ?><?php echo e($dataType->model_name); ?><?php else: ?><?php echo e($model_name); ?><?php endif; ?>">
                            </div>
                            <div class="row clearfix">
                                <div class="col-md-6 form-group">
                                    <label for="generate_permissions">Generate Permissions</label><br>
                                    <?php $checked = (isset($dataType->generate_permissions) && $dataType->generate_permissions == 1) ? true : (isset($generate_permissions) && $generate_permissions) ? true : false; ?>
                                    <input type="checkbox" name="generate_permissions" class="toggleswitch"
                                           <?php if($checked): ?> checked <?php endif; ?>>
                                </div>
                                <div class="col-md-6 form-group">
                                    <label for="server_side">Server-side Pagination</label><br>
                                    <?php $checked = (isset($dataType->server_side) && $dataType->server_side == 1) ? true : (isset($server_side) && $server_side) ? true : false; ?>
                                    <input type="checkbox" name="server_side" class="toggleswitch"
                                           <?php if($checked): ?> checked <?php endif; ?>>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea class="form-control" name="description"
                                          placeholder="Description"><?php if(isset($dataType->description)): ?><?php echo e($dataType->description); ?><?php endif; ?></textarea>
                            </div>

                            <div class="box-footer">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div><!-- .panel-body -->

                    </div><!-- .panel -->
                </form>
            </div><!-- .col-md-12 -->
        </div><!-- .row -->
    </div><!-- .page-content -->

    <script>
        function prettyPrint() {
            var ugly = document.getElementById('myTextArea').value;
            var obj = JSON.parse(ugly);
            var pretty = JSON.stringify(obj, undefined, 4);
            document.getElementById('myTextArea').value = pretty;
        }
    </script>
    <script>
        $('document').ready(function () {
            $('.toggleswitch').bootstrapToggle();
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('voyager::master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>